import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { mutationResponse } from "../../util/processResponse.js";

const initialState = {
	newAddress: {},
	loading: false,
};

export const postNewAddress = createAsyncThunk(
	"user/postNewAddress",
	async (obj) => {
		try {
			const { access_token, URL, method, address } = obj;
			const data = await mutationResponse(URL, method, address, access_token);
			return data;
		} catch (err) {
			return;
		}
	}
);

const postNewAddressSlice = createSlice({
	name: "user",
	initialState,
	reducers: {
		setNewAddress: (state, { payload }) => {
			state.newAddress = payload;
		},
		resetNewAddress: (state) => {
			state.newAddress = {};
		},
	},
	extraReducers: (builder) => {
		builder.addCase(postNewAddress.pending, (state) => {
			state.loading = true;
		});
		builder.addCase(postNewAddress.fulfilled, (state, { payload }) => {
			state.newAddress = payload;
			state.loading = false;
		});
		builder.addCase(postNewAddress.rejected, (state) => {
			state.loading = false;
		});
	},
});

export const { setNewAddress, resetNewAddress } = postNewAddressSlice.actions;
export default postNewAddressSlice.reducer;
